# -*- coding: utf-8 -*-
"""
Created on Thu Mar 10 09:48:34 2016

@author: gareth
"""

import UnitTest as test
import numpy

from CModels import CModels

print "Testing: CModels"

models = CModels()
concentrations = numpy.zeros((2,1,4), float)
concentrations[0,0,:] = [0.0, 4.0, 2.0, 0.0]
concentrations[1,0,:] = [3.0, 0.0, 2.0, 0.0]
models.AdvectionOnly.Concentrations = concentrations

models.SetReferenceModel(models.ADETransverse)
reference_concentrations = numpy.zeros((2,1,4), float)
reference_concentrations[0,0,:] = [0.0, 2.0, 1.0, 0.0]
reference_concentrations[1,0,:] = [1.0, 0.0, 1.0, 0.0]
models.ReferenceModel.Concentrations = reference_concentrations

expected = [2.0, 2.0, 1.0, 0.0]
test.Compare(expected,models.PeakConcentrationsOverTimeResiduals(models.AdvectionOnly))

#######################################

models = CModels()
concentrations = numpy.zeros((2,1,4), float)
concentrations[0,0,:] = [0.0, 4.0, 2.0, 0.0]
concentrations[1,0,:] = [3.0, 0.0, 2.0, 0.0]
models.AdvectionOnly.Concentrations = concentrations

models.SetReferenceModel(models.AdvectionOnly)

expected = [0.0, 0.0, 0.0, 0.0]
test.Compare(expected,models.PeakConcentrationsOverTimeResiduals(models.AdvectionOnly))

####################

models = CModels()
concentrations = numpy.zeros((2,1,4), float)
concentrations[0,0,:] = [0.0, 4.0, 2.0, 0.0]
concentrations[1,0,:] = [1.0, 0.0, 2.0, 0.0]
models.AdvectionOnly.Concentrations = concentrations
#peak concentrations = [1, 4, 2, 0]
#normalized concentrations = [0.25,1,0.5,0]


models.SetReferenceModel(models.ADETransverse)
reference_concentrations = numpy.zeros((2,1,4), float)
reference_concentrations[0,0,:] = [0.0, 2.0, 1.0, 0.0]
reference_concentrations[1,0,:] = [1.0, 0.0, 1.0, 0.0]
# peak concentrations = [1,2,1,0]
# normalised concentrations = [0.5, 1, 0.5, 0]
models.ReferenceModel.Concentrations = reference_concentrations


expected = [-0.25, 0.0, 0.0, 0.0]
test.Compare(expected,models.PeakNormalisedConcentrationsOverTimeResiduals(models.AdvectionOnly))


